import Validator from "ajv";

const schemas = [
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Boolean.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Date.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Decimal.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Integer.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Percentage.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column/Text.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Row/Field/Boolean.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Row/Field/Number.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Row/Field/String.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Row/Field.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Column.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table/Row.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Map.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Serial.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Table.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Text.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data/Number.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Option/Checkbox.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Option/Dropdown.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Option/Number.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Option/Text.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Author.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Data.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Height.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/HorizontalPosition.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Icon.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Id.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Label.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Option.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Options.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Title.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Type.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/UpdateSet.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Version.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/VerticalPosition.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Visualization.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/Definition/Width.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/GetAvailableWidgetsResponseBody.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/GetWidgetsResponseBody.json"),
    require("./../../../../App/Overview/Model/ValueObjects/Schema/Json/GetWidgetResponseBody.json"),
];

const validator = new Validator({ schemas });

export enum Schema {
    GetAvailableWidgetsResponseBody = "https://gambio.com/schema/GetAvailableWidgetsResponseBody.json",
    GetWidgetsResponseBody = "https://gambio.com/schema/GetWidgetsResponseBody.json",
    GetWidgetResponseBody = "https://gambio.com/schema/GetWidgetResponseBody.json",
}

export async function validateSchema(schemaName: Schema, data: any): Promise<void> {
    const schemaValidator = validator.getSchema(schemaName);
    const messageId = Date.now();

    if (!schemaValidator) {
        throw new Error(`Schema ${schemaName} has not been found`);
    }

    if (!(await schemaValidator(data))) {
        console.group(messageId);
        console.dir(schemaValidator?.errors);
        console.groupEnd();
        throw new Error(
            [
                `Failed to validate data against schema. Check console message ${messageId} for detailed information.`,
                "",
                `Schema tested: ${schemaName}`,
                "",
                `Data provided: ${data}`,
            ].join("\n")
        );
    }
}
